<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category  Symmetrics
 * @package   Symmetrics_InvoicePdf
 * @author    symmetrics gmbh <info@symmetrics.de>
 * @author    Torsten Walluhn <tw@symmetrics.de>
 * @copyright 2010 symmetrics gmbh
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * @link      http://www.symmetrics.de/
 */

/**
 * Abstract Pdf Rendering class
 *
 * @category  Symmetrics
 * @package   Symmetrics_InvoicePdf
 * @author    symmetrics gmbh <info@symmetrics.de>
 * @author    Torsten Walluhn <tw@symmetrics.de>
 * @copyright 2010 symmetrics gmbh
 * @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * @link      http://www.symmetrics.de/
 */
class Symmetrics_InvoicePdf_Model_Pdf_Invoice extends Symmetrics_InvoicePdf_Model_Pdf_Abstract
{
    /**
     * Container to store the current invoice
     *
     * @var Mage_Sales_Model_Order_Invoice
     */
    protected $_invoice;
    
    

    /**
     * function to render the invoice/s as PDF
     *
     * @param array $invoices array of invices
     *
     * @return Zend_Pdf
     */
    public function getPdf($invoices = array())
    {
        $this->_beforeGetPdf();
        $this->_initRenderer('invoice');
        
        $pdf = $this->_getPdf();

        foreach ($invoices as $invoice) {
            if ($invoice->getStoreId()) {
                Mage::app()->getLocale()->emulate($invoice->getStoreId());
            }
            
            $this->_invoice = $invoice;
            
            $settings = new Varien_Object();
            $order = $invoice->getOrder();
            
            $settings->setStore($invoice->getStore());
            
            $page = $this->newPage($settings);
            
            /* Add image */
            //$this->insertLogo($page, $invoice->getStore());

            /* Add head */
            $this->insertOrder(
                $page, 
                $order, 
                Mage::helper('invoicepdf')->getSalesPdfInvoiceConfigFlag(
                    self::PDF_INVOICE_PUT_ORDER_ID, 
                    $order->getStoreId()
                )
            );
            
            $this->setSubject($page, Mage::helper('sales')->__('Invoice'));
			/* Add body */
            foreach ($invoice->getAllItems() as $item) {
                if ($item->getOrderItem()->getParentItem()) {
                    continue;
                }

                /* Draw item */
                $page = $this->_drawItem($item, $page, $order);
            }
			$font = $this->_setFontRegular($page);
            $this->_newLine($font, 10);
            /* Add additional info */
            
            //$page = $this->_insertAdditionalInfo($page, $order); // auskommentiert weil der Kunde das nicht haben möchte
            /* Add totals */
            $page = $this->insertTotals($page, $invoice);
			
            $this->_newLine($font, 20);

            /* Insert info text */
            //$page = $this->_insertInfoText($page, $order); // auskommentiert weil der Kunde das nicht haben möchte

            /* Insert info box */
            //$page = $this->_insertInfoBlock($page, $order); // auskommentiert weil der Kunde das nicht haben möchte
            
            // add info and tickets
            $this->_current_page = $page;
            $this->addBackgroundTemplate();
            $this->_current_page = $this->newPage($settings);
        	$this->addInfoPage();
            foreach ($invoice->getAllItems() as $item) {
                if ($item->getOrderItem()->getParentItem()) {
                    continue;
                }

                /* Draw item */
                /* @var $item Mage_Catalog_Model_Product */
                if ($item->getSku() != Mage::getStoreConfig( "fandm/mandatoryitems/default_sku")
                	&& $item->getSku() != Mage::getStoreConfig("fandm/mandatoryitems/sku1")) {
                	for ($i = 0; $i < $item->_data["qty"]; $i++) {
                		$this->_current_page = $this->newPage($settings);
                		$this->addBackgroundTemplate();
	                	$this->insertTicket($item, $i);
                	}
                }
            }          
        	if ($invoice->getStoreId()) {
                Mage::app()->getLocale()->revert();
            }
        }
        
        $this->_afterGetPdf();
        return $this->_pdf;
    }
    
    
    public function addInfoPage() {
    	$page = $this->_current_page;
    	$this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 20);
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__('Please consider the following instructions:'), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $text_array = explode("\\n", 
        	Mage::helper('sales')->__("The amount of invoice %s € is charged in the order, in the name and on behalf of the Humboldt University of Berlin\\nby x:hibit GmbH", 
        	sprintf("%.2f", $this->_invoice->_data["subtotal_incl_tax"])));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("The cancellation period for the entire booking is 7 days before the tour date."), 
            Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Online tickets cannot be refunded."), 
            Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
            
        $this->drawNewRightAllowedLine(
        	"Online-Tickets:", 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $text_array = explode("\\n", 
        	Mage::helper('sales')->__("Please print out the tickets, each on one page A4 portrait format and show it to the control at the exhibition entrance."));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
            
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Private group tours:"), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
    	$text_array = explode("\\n", 
        	Mage::helper('sales')->__("info_text1"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
    	$text_array = explode("\\n", 
        	Mage::helper('sales')->__("info_text2"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Please leave coats and large handbags at the wardrobe before the start of your tour."), 
            Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Public Tours:"), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 6);
        $text_array = explode("\\n", 
        	Mage::helper('sales')->__("The meeting place for group tours of the exhibition is signposted in the foyer of the Martin-Gropius-Bau. Please arrive in time."));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
    	$this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Address").":", 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->drawNewRightAllowedLine("Martin-Gropius-Bau Berlin", 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->drawNewRightAllowedLine("Niederkirchnerstr. 7", 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->drawNewRightAllowedLine("10963 Berlin", 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
    	$this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Access:"), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Subway Line 2 (station: Potsdamer Platz)"), 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("S-Bahn lines 1, 2, 25 (stops: Potsdamer Platz station or Anhalter Bahnhof)"), 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Buses: M29 (stop Anhalter Bahnhof) | M41 (stop House of Representatives Berlin)"), 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
        $this->drawNewRightAllowedLine(
        	Mage::helper('sales')->__("Opening times:"), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("24th September 2010 - 9 January 2011"), 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Wednesday - Monday 10 - 20 clock, closed Tuesday"), 
           	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 30);
        $text_array = explode("\\n", 
        	Mage::helper('sales')->__("Yours sincerely,\\nVisitor Services WeltWissen"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        
    }
    
    public function addBackgroundTemplate() {
    	$page = $this->_current_page;
    	$this->insertImage("invoice_template_background.JPG");
    	$page->drawText(Mage::helper('sales')->__('ticket_template_bottom1'), 
    		self::PAGE_POSITION_LEFT + 30, self::PAGE_POSITION_BOTTOM, "UTF-8");
    	$page->drawText(Mage::helper('sales')->__('ticket_template_bottom2'), 
    		self::PAGE_POSITION_LEFT + 130 , self::PAGE_POSITION_BOTTOM - 13, "UTF-8");
    		
    	$addrLeft = self::PAGE_POSITION_RIGHT - 170;
    	$addrTop = self::PAGE_POSITION_TOP - 120; 
    	
    	$fontSize = 8;
    	$font = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_BOLD_ITALIC);
    	$this->_current_page->setFont($font, $fontSize);
    	
    	$page->drawText("Webshop WeltWissen", 
    		$addrLeft, $addrTop, "UTF-8");
    	$addrTop -= $this->heightForFontUsingFontSize($font, $fontSize) * 1.2;
    	
    	$font = Zend_Pdf_Font::fontWithName(Zend_Pdf_Font::FONT_HELVETICA_ITALIC);
    	$this->_current_page->setFont($font, $fontSize);
    	
    	$page->drawText("Tel. 030 - 263 966 41", 
    		$addrLeft, $addrTop, "UTF-8");
    	$addrTop -= $this->heightForFontUsingFontSize($font, $fontSize) * 1.2;
    	
    	$page->drawText("Fax  030 - 263 966 40", 
    		$addrLeft, $addrTop, "UTF-8");
    	$addrTop -= $this->heightForFontUsingFontSize($font, $fontSize) * 1.2;
    	
    	$page->drawText("webshop-weltwissen@xhibit.de", 
    		$addrLeft, $addrTop, "UTF-8");
    	$addrTop -= $this->heightForFontUsingFontSize($font, $fontSize) * 1.2;
    	$page->drawText("www.weltwissen-berlin.de", 
    		$addrLeft, $addrTop, "UTF-8");    		
    }
    
    protected function convertToBarcodeString($toBarcodeString)
    {
        $str = $toBarcodeString;
        $barcode_data = str_replace(' ', chr(128), $str);

        $checksum = 104; # must include START B code 128 value (104) in checksum
        for($i=0;$i<strlen($str);$i++) {
                $code128 = '';
                if (ord($barcode_data{$i}) == 128) {
                        $code128 = 0;
                } elseif (ord($barcode_data{$i}) >= 32 && ord($barcode_data{$i}) <= 126) {
                        $code128 = ord($barcode_data{$i}) - 32;
                } elseif (ord($barcode_data{$i}) >= 126) {
                        $code128 = ord($barcode_data{$i}) - 50;
                }
        $checksum_position = $code128 * ($i + 1);
        $checksum += $checksum_position;
        }
        $check_digit_value = $checksum % 103;
        $check_digit_ascii = '';
        if ($check_digit_value <= 94) {
            $check_digit_ascii = $check_digit_value + 32;
        } elseif ($check_digit_value > 94) {
            $check_digit_ascii = $check_digit_value + 50;
        }
        $barcode_str = chr(154) . $barcode_data . chr($check_digit_ascii) . chr(156);
            
        return $barcode_str;

    }
    
    public function insertTicket($item, $order_item_counter) {
    	$page = $this->_current_page;
    	
    	// draw ticket name
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 40);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 30);
        $this->drawNewRightAllowedLine("Ticket", Zend_Pdf_Font::FONT_HELVETICA_BOLD, 16);
        
        /* Add Barcode (custom: Matt Johnson 2008-06-13)*/
        /* convertToBarcodeString resides in extended abstract.php file*/
    	$read_sql = "select ticket_number from fandm_visitatebarcodes_ticket where ".
        	"invoice_id = ".$this->_invoice->getId()." AND ".
            "invoice_item_id = ".$item->getId()." AND ".
    		"invoice_item_counter = ".$order_item_counter;
    	$res = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchRow($read_sql);
    	$barcode = "";
		if (count($res) > 0) {
			$barcode = $res["ticket_number"];
			$barcodeString = $this->convertToBarcodeString($res["ticket_number"]);
		} else {
			$barcode = $item->getId();
			$barcodeString = $this->convertToBarcodeString($item->getId());
		}
        
        
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 24);
        
        //$page->setFillColor(new Zend_Pdf_Color_RGB(0, 0, 0));
        $page->setFont(Zend_Pdf_Font::fontWithPath(dirname(__FILE__)  . '/' . 'Code128bWin.ttf'), 18);
        $page->drawText($barcodeString, self::PAGE_POSITION_LEFT, $this->_height, 'CP1252');
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__('Ticket #')." ".$barcode, Zend_Pdf_Font::FONT_HELVETICA, 8);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__('Invoice #')." ".$this->_invoice->getIncrementId(), Zend_Pdf_Font::FONT_HELVETICA, 8);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__('Order #').$this->_invoice->getOrder()->getRealOrderId(), Zend_Pdf_Font::FONT_HELVETICA, 8);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 24);
        
        // add time
        $var = unserialize($item->getOrderItem()->_data["product_options"]);
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__('Date').":", 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $from_date = explode(".", $var["info_buyRequest"]["aw_booking_from"]);
        $from_date = $from_date[2]."-".$from_date[1]."-".$from_date[0];
        $timestamp = strtotime($from_date);
        $day = strftime("%A, %d.%m.20%y", $timestamp);
        $this->drawText($day, 150, 
        	Zend_Pdf_Font::FONT_HELVETICA, 9);
            
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Time frame for admission:"), 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        if (isset($var["info_buyRequest"]["aw_booking_time_from"]["hours"])) {
        	$time_from = $var["info_buyRequest"]["aw_booking_time_from"]["hours"].":".$var["info_buyRequest"]["aw_booking_time_from"]["minutes"]. 
            	" - ".$var["info_buyRequest"]["aw_booking_time_to"]["hours"].":".$var["info_buyRequest"]["aw_booking_time_to"]["minutes"]." Uhr";
            $this->drawText($time_from, 150, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
            $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        } else {
	        $this->drawText(Mage::helper('sales')->__("Within the opening hours of the booked date"), 150,  
	        	Zend_Pdf_Font::FONT_HELVETICA, 9);
	        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 18);
        }
            
        // draw ticket name and price
        $this->drawNewRightAllowedLine("Online-Ticket", 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->drawText("".sprintf("%.2f", $item->getPrice())." €", 150, 
        	Zend_Pdf_Font::FONT_HELVETICA, 9);
        
        $this->drawNewRightAllowedLine($item->getName(), 
        	Zend_Pdf_Font::FONT_HELVETICA, 9);

        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
            
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Zero rated according to $4 Nr. 20USTG"), 
        	Zend_Pdf_Font::FONT_HELVETICA, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 18);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
        // Online Ticket: ...
        $this->drawNewRightAllowedLine("Online-Tickets:", 
        	Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $text_array = explode("\\n", Mage::helper('sales')->__("ticket_onlineticket_text"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 18);
            
        // Conditions ...
        $this->drawNewRightAllowedLine(Mage::helper('sales')->__("Conditions for the use of online tickets:"), 
            Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
   		$this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
   		$text_array = explode("\\n", Mage::helper('sales')->__("ticket_conditions_text1"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $text_array = explode("\\n", Mage::helper('sales')->__("ticket_conditions_text2"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $text_array = explode("\\n", Mage::helper('sales')->__("ticket_conditions_text3"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        $text_array = explode("\\n", Mage::helper('sales')->__("ticket_conditions_text4"));
        foreach ($text_array as $line) {
        	$this->drawNewRightAllowedLine($line, 
            	Zend_Pdf_Font::FONT_HELVETICA, 9);
        }
        $this->addNewLine(Zend_Pdf_Font::FONT_HELVETICA_BOLD, 9);
        
    }
    
    protected $_current_page;
    
    
    public function drawNewRightAllowedLine($text, $font_type, $font_size) {
    	$font = Zend_Pdf_Font::fontWithName($font_type);
    	$this->_current_page->setFont($font, $font_size);
    	$this->_newLine($font, $font_size);
    	$this->_current_page->drawText(
			$text,
            self::PAGE_POSITION_LEFT,
            $this->_height,
            'UTF-8'
        );
    }
    
    public function drawText($text, $left_margin, $font_type, $font_size) {
    	$font = Zend_Pdf_Font::fontWithName($font_type);
    	$this->_current_page->setFont($font, $font_size);
    	$this->_current_page->drawText(
			$text,
            self::PAGE_POSITION_LEFT + $left_margin,
            $this->_height,
            'UTF-8'
        );
    }
    
    public function drawBlock($text, $font_type, $font_size) {
        $helper = Mage::helper('invoicepdf');

        $renderer = Mage::getModel('invoicepdf/pdf_items_invoice_block');
        $renderer->setPdf($this);
        $renderer->setPage(&$this->_current_page);
        $renderer->setRenderedModel($this);

        $renderer->drawBlock($text, $font_type, $font_size);
		
        $this->_current_page = $renderer->getPage();
    }
    
    public function insertImage($image_name)
    {
        $image = Mage::getStoreConfig('system/filesystem/skin').
        	'/frontend/default/weltwissen/images/' . $image_name;
        //Mage::log("item: ".$image);
        
        if (is_file($image)) {
        	//Mage::log("item: IMAGE!");
			$size = getimagesize($image);
            $imageWidth = $size[0];
            $imageHeight = $size[1];
			
            $imageRatio = round(self::PAGE_POSITION_RIGHT - self::PAGE_POSITION_LEFT) / ($imageWidth * 2);
            $imageWidth = round($imageWidth * $imageRatio);
            $imageHeight = round($imageHeight * $imageRatio);
            
            $image = Zend_Pdf_Image::imageWithPath($image);
            $logoPosition = Mage::getStoreConfig('sales/identity/logoposition');

			$imageTopLeft = (self::PAGE_POSITION_RIGHT - self::PAGE_POSITION_LEFT) / 2;
            $imageTop = self::PAGE_POSITION_TOP - 70;
            $imageBottomRight = $imageTopLeft + $imageWidth;
            $imageBottom = self::PAGE_POSITION_TOP - 70 + $imageHeight;

        	$this->_current_page->drawImage($image, $imageTopLeft, $imageTop, $imageBottomRight, $imageBottom);
        }
    }
    
    
    public function addNewLine($font_type, $font_size) {
    	$font = Zend_Pdf_Font::fontWithName($font_type);
    	$this->_newLine($font, $font_size);
    }
    
    /**
     * Create new page and assign to PDF object
     *
     * @return Zend_Pdf_Page
     */
    public function newPage(Varien_Object $settings)
    {
        $pageSize = Zend_Pdf_Page::SIZE_A4;
        $page = $this->_getPdf()->newPage($pageSize);
        $pdf = $this->_getPdf();

        $this->_height = self::PAGE_POSITION_TOP;
        /* @var $pdf Zend_Pdf */
        $pdf->pages[] = $page;
        if (count($pdf->pages) > 1) {
            //$this->insertTableHeader($page);
            $fontSize = 9;
        	$font = $this->_setFontRegular($page, $fontSize);
        }

        // draw page number
        /*$font = $this->_setFontRegular($page, 8);
        $pageText = Mage::helper('invoicepdf')->__('Page %d', count($pdf->pages));
        $pageTextSize = $this->widthForStringUsingFontSize($pageText, $font, 8);
        $pageTextHeight = $this->heightForFontUsingFontSize($font, 8);
        $page->drawText(
            $pageText,
            self::PAGE_POSITION_RIGHT - $pageTextSize,
            self::PAGE_POSITION_BOTTOM + $pageTextHeight * 0.4,
            'UTF-8'
        );*/

        return $page;
    }

    /**
     * Insert the invoice increment id and the Order info from its parent class
     *
     * @param Zend_Pdf_Page          &$page      given page to insert order info
     * @param Mage_Sales_Model_Order $order      order to get info from
     * @param boolean                $putOrderId print order id
     *
     * @return void
     */
    protected function _insertOrderInfo(&$page, $order, $putOrderId)
    {
        parent::_insertOrderInfo($page, $order, $putOrderId);
        $this->_insertOrderInfoRow(
            $page,
            Mage::helper('sales')->__('Invoice # '),
            $this->_invoice->getIncrementId()
        );
    }

    /**
     * Insert additional info to the current invoice
     *
     * @param Zend_Pdf_Page          &$page given page to insert the addition info
     * @param Mage_Sales_Model_Order $order order to get info from
     *
     * @return Zend_Pdf_Page
     */
    protected function _insertAdditionalInfo(&$page, $order)
    {
        $helper = Mage::helper('invoicepdf');

        $renderer = Mage::getModel('invoicepdf/pdf_items_invoice_additional');
        $renderer->setOrder($order);
        $renderer->setPdf($this);
        $renderer->setPage($page);
        $renderer->setRenderedModel($this);
        $renderer->setHeight($this->_height);

        $renderer->draw();

        if ($this->_height < $renderer->getHeight()) {
            // reset the height of the additional block
            $this->_height = $renderer->getHeight();
        } else {
            // addition info was rendered on a new page
            $this->_height = self::PAGE_POSITION_TOP;
        }
        return $renderer->getPage();
    }

    /**
     * Insert info text to the current invoice
     *
     * @param Zend_Pdf_Page          &$page given page to insert info text
     * @param Mage_Sales_Model_Order $order order to get info from
     *
     * @return Zend_Pdf_Page
     */
    protected function _insertInfoText(&$page, $order)
    {
        $helper = Mage::helper('invoicepdf');

        if (!$helper->getSalesPdfInvoiceConfigFlag('showinfotxt', $order->getStore())) {
            return $page;
        }

        $renderer = Mage::getModel('invoicepdf/pdf_items_invoice_info');
        $renderer->setOrder($order);
        $renderer->setPdf($this);
        $renderer->setPage($page);
        $renderer->setRenderedModel($this);

        $renderer->draw();

        return $renderer->getPage();
    }

    /**
     * Insert info text to the current invoice
     *
     * @param Zend_Pdf_Page          &$page given page to insert info text
     * @param Mage_Sales_Model_Order $order order to get info from
     *
     * @return Zend_Pdf_Page
     */
    protected function _insertInfoBlock(&$page, $order)
    {
        $helper = Mage::helper('invoicepdf');

        if (!$helper->getSalesPdfInvoiceConfigFlag('showinfobox', $order->getStore())) {
            return $page;
        }

        $renderer = Mage::getModel('invoicepdf/pdf_items_invoice_block');
        $renderer->setOrder($order);
        $renderer->setPdf($this);
        $renderer->setPage($page);
        $renderer->setRenderedModel($this);

        $renderer->draw();

        return $renderer->getPage();
    }
}
