<?php

class FandM_SearchCalendar_Block_Results extends Mage_Core_Block_Template
{
	protected $_productCollection;
	
	public function _construct()
    {
    	parent::_construct();
    	$params = $this->getRequest()->getParams();
    	
    	$productModel = Mage::getModel("catalog/product");
    	$this->_productCollection = $productModel->getCollection();
    	if (isset($params['byday'])) {
    		$day = new Zend_Date($params['byday'], 'de_DE');
    		$this->_productCollection->addAttributeToFilter("aw_booking_date_to", array('date' => true, 'from' => $day->toString('yyyy-MM-dd')));
	    	$this->_productCollection->addAttributeToFilter("aw_booking_date_from", array('date' => true, 'to' => $day->toString('yyyy-MM-dd')));
    	} else if (isset($params['bymonth'])) {
    		$month = new Zend_Date($params['bymonth'], 'de_DE');
    		$month->setDay(1);
    		$this->_productCollection->addAttributeToFilter("aw_booking_date_to", array('date' => true, 'from' => $month->toString('yyyy-MM-dd')));
    		$month->setDay($month->get(Zend_Date::MONTH_DAYS));
    		$this->_productCollection->addAttributeToFilter("aw_booking_date_from", array('date' => true, 'to' => $month->toString('yyyy-MM-dd')));
    	}
    	foreach ($this->_productCollection as $product) {
    		$product->load($product->getId());
    	}
    }	
    
    /**
     * Prepare layout
     *
     * @return Mage_SearchCalendar_Block_Results
     */
    protected function _prepareLayout()
    {
        // add Home breadcrumb
        $breadcrumbs = $this->getLayout()->getBlock('breadcrumbs');
        if ($breadcrumbs) {
        	$queryText = "";
        	$params = $this->getRequest()->getParams();
        	if (isset($params['byday'])) {
        		$queryText = $params['byday'];
        	} else if (isset($params['bymonth'])) {
        		$month = new Zend_Date($params['bymonth'], 'de_DE');
        		$queryText = $month->get(Zend_Date::MONTH_NAME, Mage::app()->getLocale()->getLocaleCode()).' '.$month->get(Zend_Date::YEAR);
        	}
            $title = $this->__("Search results for: '%s'", $queryText);

            $breadcrumbs->addCrumb('home', array(
                'label' => $this->__('Home'),
                'title' => $this->__('Go to Home Page'),
                'link'  => Mage::getBaseUrl()
            ))->addCrumb('search', array(
                'label' => $title,
                'title' => $title
            ));
        }

        // modify page title
        $title = $this->__("Search results for: '%s'", $queryText);
        $this->getLayout()->getBlock('head')->setTitle($title);

        return parent::_prepareLayout();
    }
    
    public function getLoadedProductCollection() {
    	//$this->_productCollection->load();
    	return $this->_productCollection;
    }
}
