<?php
/**
 * aheadWorks Co.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://ecommerce.aheadworks.com/LICENSE-M1.txt
 *
 * @category   AW
 * @package    AW_Booking
 * @copyright  Copyright (c) 2009-2010 aheadWorks Co. (http://www.aheadworks.com)
 * @license    http://ecommerce.aheadworks.com/LICENSE-M1.txt
 */

class AW_Booking_Model_Mysql4_Order extends Mage_Core_Model_Mysql4_Abstract {
    protected function _construct() {
        $this->_init('booking/order', 'id');
    }

    /**
     * Cancel bind by id
     * @param int $id
     * @return AW_Booking_Model_Mysql4_Order
     */
    public function cancelByOrderId($id) {
        $this->_getWriteAdapter()->update($this->getMainTable(), array('is_canceled' => 1),'order_id='.($id));
        return $this;
    }

    /**
     * Delete by quote item id
     * @param Mage_Sales_Model_Quote_Item $QuoteItem
     * @return AW_Booking_Model_Mysql4_Order
     */
    public function deleteByQuoteItem(Mage_Sales_Model_Quote_Item $QuoteItem) {
        $condition =   "bind_type='".AW_Booking_Model_Order::BIND_TYPE_CART."' AND order_id=".intval($QuoteItem->getId());
        $this->_getWriteAdapter()->delete($this->getMainTable(), $condition);
        return $this;
    }

    /**
     * Updates product title for product id
     * @param int $productId
     * @param string $title
     * @param int $storeId
     */
    public function setProductNameById($productId, $title, $storeId=null) {
        $db = $this->_getWriteAdapter();

        $prop = array(
            'product_name' => $title
        );

        if(!is_null($storeId)) {
            $db->update($this->getMainTable(), $prop, $db->quoteInto('product_id=?', $productId));
        }
        else {
            $db->update($this->getMainTable(), $prop, $db->quoteInto('product_id=?', $productId));
        }
    }

}
