<?php

/**
 * @category	Mage
 * @package	FandM_Anrede
 * @developer	Wolfgang Price (wp@f-m-computer.de)
 * @version	0.1
 */

class FandM_Anrede_Model_Sales_Order extends Mage_Sales_Model_Order
{
	private $_prefix = false;
	private $_lastname = false;
	private $_suffix = false;
	
	protected $_anreden = array('Frau', 'Herr', 'Familie');
	
    public function getCustomerNameFormal() {
		Mage::log('Called  getCustomerNameFormal()');
		$customerNameFormal = '';

		if ($this->getCustomerIsGuest()) {
			$address = $this->getBillingAddress();
			if ($address->getPrefix()) {
				$this->_prefix = $address->getPrefix();
				$this->_lastname = $address->getLastname();
				$this->_suffix = $address->getSuffix();
			}
		} else {
			if ($this->getCustomerPrefix()) {
				$this->_prefix = $this->getCustomerPrefix();
				$this->_lastname = $this->getCustomerLastname();
				$this->_suffix = $this->getCustomerSuffix();
			}
		}
		
		if ($this->_prefix) {
			if (in_array($this->_prefix, $this->_anreden)) {
				$customerNameFormal .= 'Sehr geehrte';
				if ($this->_prefix == 'Herr') {
					$customerNameFormal .= 'r';
				}
				$customerNameFormal .= ' ' . $this->_prefix . ' ';
			}
		}
		$customerNameFormal .=  $this->_lastname;
		
		if ($this->_suffix) {
			$customerNameFormal .= ' ' . $this->_suffix;
		}
	Mage::log('getCustomerNameFormal() returns ' . $customerNameFormal);
		return $customerNameFormal;
    }

}