<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@idealiagroup.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this module to newer
 * versions in the future.
 *
 * @category   IG
 * @package    IG_CashOnDelivery
 * @copyright  Copyright (c) 2010-2011 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * @author     Riccardo Tempesta <tempesta@idealiagroup.com>
*/
 
class FandM_BarcodeTickets_Model_Ticket extends Mage_Core_Model_Abstract
{
	
	protected $_item = null;
	protected $_options = null;
	
	public function _construct() {
		parent::_construct();
		$this->_init('barcodetickets/ticket');
	}
	
	public function setInvoiceItem($invoiceItem) {
		if($invoiceItem instanceof Mage_Sales_Model_Order_Invoice_Item ) {
			$this->_item = $invoiceItem;
		}
	}
	
	/**
	 * @return Mage_Sales_Model_Order_Invoice_Item
	 */
	public function getInvoiceItem() {
		if (is_null($this->_item)) {
			/* @var $invoice Mage_Sales_Model_Order_Invoice */
			Mage::log('Get Invoice ('. $this->getData("invoice_id").'):');//.print_r($this->_item,true));
			$invoice = Mage::getModel("sales/order_invoice");
			$invoice->load($this->getData("invoice_id"));
			$this->_item = $invoice->getItemById($this->getData("invoice_item_id"));
		}
		return $this->_item;
	}
	
	private function getItemOptions() {
		if (is_null($this->_options)) {
			if (isset($this->getInvoiceItem()->getOrderItem()->_data['product_options'])) {
				$this->_options = unserialize($this->getInvoiceItem()->getOrderItem()->_data["product_options"]);
			} else {
				$this->_options = false;
			}
		}
		return $this->_options;
	}
	
	/**
	 * @return Mage_Catalog_Model_Product
	 */
	public function getProduct() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["product"])) {
			$id = $options["info_buyRequest"]["product"];
			/* @var $product Mage_Catalog_Model_Product */
			$product = Mage::getModel("catalog/product");
			$product->load($id);
			return $product;
		}
		return false;
	}
	
	private function getTimestamp($date, $time) {
		$retDate = new Zend_Date();
		$retDate->setTimezone('Europe/Berlin');
		
		if (!$date)
			return false;
		if (strpos($date,'/') === false) 
			$retDate->setDate($date, "dd.MM.yy",'de_DE');
		else 
			$retDate->setDate($date, "MM/dd/yy",'de_DE');
		$retDate->setTime("00:00:00", "HH:mm:ss");
		if ($time)
			$retDate->setTime($time.":00", "HH:mm:ss");
		return $retDate;
	}
	
	/**
	 * @return Zend_Date
	 */
	public function getTimestampFrom() {
		return $this->getTimestamp($this->getAWFromDate(), $this->getAWTimeFrom());
	}
	
	/**
	 * @return Zend_Date
	 */
	public function getTimestampTo() {
		return $this->getTimestamp($this->getAWToDate(), $this->getAWTimeTo());
	}
	
	public function isTimeslotTicket() {
		return $this->getAWTimeFrom() && $this->getAWTimeTo();
	}
	

	private function getAWFromDate() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_from"])) {
			return $options["info_buyRequest"]["aw_booking_from"];
		}
		return false;
	}
	
	private function getAWToDate() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_to"])) {
			return $options["info_buyRequest"]["aw_booking_to"];
		}
		return false;
	}

	private function getAWTimeFrom() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_time_from"]["hours"])) {
        	return $options["info_buyRequest"]["aw_booking_time_from"]["hours"] . ":" .
        		   $options["info_buyRequest"]["aw_booking_time_from"]["minutes"]; 
		}
		return false;
	}
	
	private function getAWTimeTo() {
		$options = $this->getItemOptions();
		if (isset($options["info_buyRequest"]["aw_booking_time_to"]["hours"])) {
        	return $options["info_buyRequest"]["aw_booking_time_to"]["hours"] . ":" . 
        		   $options["info_buyRequest"]["aw_booking_time_to"]["minutes"];
		}
		return false;
	}
	
	
}
