<?php

class ESSO_Giveaways_Model_Observer
{
	public function __construct()
	{
		
	}
	
    /**
     * Retrieve shopping cart model object
     *
     * @return Mage_Checkout_Model_Cart
     */
    protected function _getCart()
    {
        return Mage::getSingleton('checkout/cart');
    }
	
    /**
     * Load Product by SKU Number
     *
     * @return Mage_Catalog_Model_Product || false
     */
    function loadProductBySKU($sku)
    {
	$store_product = Mage::getModel('catalog/product')
	        	   ->setStoreId(Mage::app()->getStore()->getId());

        $product = $store_product->loadByAttribute("sku", $sku);
	Mage::log($product);
        if ($product && $product->getStockItem()->getIsInStock())
        	return $store_product->load($product->getId()); 
	  else
		Mage::log('NOT IN STOCK');
    }
    
	/**
	* 
	* @param   Varien_Event_Observer $observer
	*/
	public function post_add($observer)
	{
		if (Mage::getStoreConfig('esso/giveaways/enabled'))
		{
			$cart   = $this->_getCart();
			$skus = Array();
			$skus[] = Mage::getStoreConfig( "esso/giveaways/product_sku");
			$skus[] = Mage::getStoreConfig( "esso/giveaways/product_sku_2");
			$skus[] = Mage::getStoreConfig( "esso/giveaways/product_sku_3");
			foreach ($skus as $sku) {
				Mage::log('Giveaway: ' . $sku);
				if ($sku) {
				    	$moa_product = $this->loadProductBySKU($sku);
				        // add default product if not allready in Cart
				        if ($moa_product && !in_array($moa_product->getId(), $cart->getProductIds())) {
		       		 	$cart->addProduct($moa_product);
		        			$cart->save();	
						Mage::log('...added to cart.');
				        }
		        	}
			}
			return $this;
		}
	}

}
