<?php 
class FDA_Carousel_Block_Carousel extends Mage_Core_Block_Template implements Mage_Widget_Block_Interface {
    /**
     * A model to serialize attributes
     * @var Varien_Object
     */
    protected $_serializer = null;
    
    /**
     * Initialization
     */
    protected function _construct() {
        $this->_serializer = new Varien_Object();
        parent::_construct();
    }
    
    /**
     * Produce links list rendered as html
     *
     * @return string
     */
    protected function _toHtml() {
		$html = '';
		$list = array(
            'scrollTime' => $this->getData('scrollTime'),
			'scrollSpeed' => $this->getData('scrollSpeed'),
			"selector" => $this->getData('selector'),
        );
		$list['categories'] = array();
    	
		$categoriIds = explode(",",$this->getData('categories'));
		foreach($categoriIds as $catId) {
			$pos = strrpos($catId, "!");
			$linkIt = true;
			if ($pos > 0) {
				$catId = substr($catId, 0,$pos);
				$linkIt = false;
			}
			$cat = Mage::getModel('catalog/category')->load($catId);
			if($cat->getId())
				$list['categories'][$cat->getId()] = array("name"=>$cat->getName(),"imgUrl"=>$cat->getImageUrl(),"url"=>$cat->getUrl(),"linkit"=>$linkIt);
		}
		$this->assign('list', $list);
        return parent::_toHtml();
    }
}
?>
