<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magentocommerce.com for more information.
 *
 * @category    Mage
 * @package     Mage_Catalog
 * @copyright   Copyright (c) 2010 Magento Inc. (http://www.magentocommerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */


/**
 * Catalog navigation
 *
 * @category   Mage
 * @package    Mage_Catalog
 * @author      Magento Core Team <core@magentocommerce.com>
 */
class FandM_Navigations_Block_Navigation extends Mage_Catalog_Block_Navigation
{
    
    public function getChildCategoryTree() {
    	$categories = $this->getStoreCategories();    
    	$layer = Mage::getSingleton('catalog/layer');
        $category   = $layer->getCurrentCategory();
        /* @var $category Mage_Catalog_Model_Category */
        /* @var $root_category Mage_Catalog_Model_Category */
        while(!$category->getParentCategory()->isEmpty() && $category->getParentCategory()->getId() != Mage::app()->getStore()->getRootCategoryId()) {
        	
        	$category = $category->getParentCategory();
        }
        foreach ($categories as $root_category) {
        	if ($root_category->getId() == $category->getId()) {
        		return $root_category->getChildren();
        	}
        }
        return null;
    }

}
