<?php

class FandM_SearchCalendar_Block_Timeline extends Mage_Core_Block_Template
{
	protected $_curr_month;
	protected $_curr_day;
    public function _construct()
    {
    	parent::_construct();
    	$params = $this->getRequest()->getParams();
    	if (isset($params["bymonth"])) {
    		$this->_curr_month = new Zend_Date($params["bymonth"], "dd.MM.yyyy");
    	} else {
    		$this->_curr_month = null;
    	}
    	if (isset($params["byday"])) {
    		$this->_curr_day = $this->_curr_month = new Zend_Date($params["byday"], "dd.MM.yyyy");
    	} else {
    		$this->_curr_day = null;
    	}
        
        $this->setTemplate('page/html/search_calendar.phtml');
    }
    
	/**
     * Array of monthes
     * array(
     *  [$index] => array(
     *  				['month']
     *                  ['monthNameShort']
     *                  ['monthNameFull']
     *                  ['isMonth']
     *                  ['isSelected']
     *              )
     * )
     * @var array
     */
    protected $_months = null;
    
    /**
     * Array of Dates
     * array(
     *  [$index] => array(
     *                  ['day']
     *                  ['isToday']
     *                  ['isSelected']
     *                  ['isBehind']
     *              )
     * )
     * @var array
     */
    protected $_days = null;
          
	public function getMonths(){
		if ($this->_months == null) {
			$this->_months = array();
			$now = new Zend_Date();
			for ($i = 0; $i < 12; $i++) {
				$month = array();
				$month["month"] = $now->toString("dd.MM.yyyy");
				$month["monthNameShort"] = $now->get(Zend_Date::MONTH_NAME_SHORT, Mage::app()->getLocale()->getLocaleCode());
				$month["monthNameFull"] = $now->get(Zend_Date::MONTH_NAME, Mage::app()->getLocale()->getLocaleCode());
				$month["isMonth"] = ($i == 0)? true : false;
				$month["isSelected"] = $this->_curr_month != null && $now->get(Zend_Date::MONTH) == $this->_curr_month->get(Zend_Date::MONTH);
				array_push($this->_months, $month);
				$now->addMonth(1);
			}	
		}
		return $this->_months;
	}
	
	public function getDates(){
		if ($this->_days == null) {
			$this->_days = array();
			$now = new Zend_Date();
			if ($this->_curr_month != null) { 
				$now->setMonth($this->_curr_month->get(Zend_Date::MONTH));
				$now->setYear($this->_curr_month->get(Zend_Date::YEAR));
			}
			$today = new Zend_Date();
			$now->setDay(1);
			for ($i = 1, $ndays = $now->get(Zend_Date::MONTH_DAYS);  $i <= $ndays; $i++) {
				$day = array();
				$day["day"] = $now->toString("dd.MM.yyyy");
				$day["dayName"] = $i;
				$day["isToday"] = $now->isToday();
				$day["isBehind"] = $now->isEarlier($today);
				$day["isSelected"] = $this->_curr_day != null && $now->get(Zend_Date::DAY) == $this->_curr_day->get(Zend_Date::DAY);
				$now->addDay(1);
				array_push($this->_days, $day);
			}
		}
		return $this->_days;
	}
	
}
