<?php

class FandM_VisitateBarcodes_Model_Observer
{
    public function __construct() {
    }
    
    /**
     * 
     * @param Varien_Event_Observer $observer
     */
    public function make_invoice($observer) {
    	Mage::log("make_invoice");
    	if (Mage::getStoreConfig('fandm/visitatebarcodes/enabled')) {
    		Mage::log("plugin active");
	    	$event = $observer->getEvent();
	    	$invoice = $event->getInvoice();
	    	Mage::log("for foreach");
	    		foreach($invoice->getAllItems() as $item) {
	    			/* @var $item Mage_Sales_Model_Order_Invoice_Item */
	    			if ($item->getSku() != Mage::getStoreConfig( "fandm/mandatoryitems/default_sku")
	                	&& $item->getSku() != Mage::getStoreConfig("fandm/mandatoryitems/sku1")) {
	                	$customer_id = Mage::getStoreConfig('fandm/visitatebarcodes/customer_id');
	                	for ($i = 0; $i < $item->getQty(); $i++) {
	                		$article_id = str_replace("-", "", $item->getSku());
	                		/* @var $ticket FandM_VisitateBarcodes_Model_Ticket */
	    					$ticket = Mage::getModel('visitatebarcodes/ticket');
			    			$ticket->setData("invoice_id", $invoice->getId());
					    	$ticket->setData("invoice_item_id", $item->getId());
					    	$ticket->setData("invoice_item_counter", $i);
					    	$ticket->setData("customer_id", $invoice->getOrder()->getData("customer_id", 0));
					    	$ticket->setData("article_id", $article_id);
							$ticket->setData("price", $item->getPrice());
							if ($ticket->getTimestampFrom())
								$ticket->setData("entrance_ts", $ticket->getTimestampFrom()->toString('Y-MM-dd HH:mm:ss'));
							
							// chech if führung
							$product = $ticket->getProduct();
							if ($product && !$product->getData("fm_is_entrance_ticket")) {
								$ticket->setData("counter", 0);
    							$ticket->setData("validated", date("Y-m-d H:i:s", time()));
    							$ticket->setData("validated_by", "SYSTEM");
							}
							
					       	$ticket->save();
					    	
	        				$ticket->setData("ticket_number", 
					    		"000".
					    		$this->zero_fill($customer_id, 3).
					    		$this->zero_fill($article_id, 7).
					    		$this->zero_fill($ticket->getData("id", 0), 7));
					    	$ticket->save();
	                	}
	               	}
	    		}

	  			$invoice->sendEmail(true, '');
                $invoice->setEmailSent(true);

				// Bestellung auf "complete" setzen
                $order = $invoice->getOrder();
                $order->addStatusHistoryComment(Mage::helper('saferpaynew')->__('E-Mail mit Rechnung und Ticket(s) wurde versandt.'),
                                                Mage_Sales_Model_Order::STATE_COMPLETE)
                      ->setIsCustomerNotified(true)
                      ->save();
            }
        return $observer;
    }
    
    public function zero_fill($str, $len) {
    	for($i = strlen($str); $i < $len; $i++) {
    		$str = "0".$str;
    	}
    	return $str;
    }

}
