<?php

/**
 * @category	Mage
 * @package	FandM_Anrede
 * @developer	Wolfgang Price (wp@f-m-computer.de)
 * @version	0.1
 */

class FandM_Anrede_Model_Customer_Customer extends Mage_Customer_Model_Customer
{
	private $_anreden = array('Frau', 'Herr');
	
    public function getNameFormal() {
        $nameFormal = '';
		$helper = Mage::helper('customer/address');
		
		if ($helper->canShowConfig('prefix_show') && $this->getPrefix()) {
			if (in_array($this->getPrefix(), $this->_anreden)) {
				$nameFormal .= 'Sehr geehrte';
				if ($this->getPrefix() == 'Herr') {
					$nameFormal .= 'r';
				}
				$nameFormal .= ' ';
			}
			
		} 
		$nameFormal .= $this->getName();
		
		return $nameFormal;
    }

    public function getNameFormalShort() {
        $nameFormal = '';
		
        $helper = Mage::helper('customer/address');
        if ($helper->canShowConfig('prefix_show') && $this->getPrefix()) {
			$nameFormal .= $this->getPrefix() . ' ' . $this->getLastname();
			if ($this->getSuffix()) {
				$nameFormal .= ' ' . $this->getSuffix();
			}
			return $nameFormal;
		} else {
			return $this->getName();
		}
    }
}