<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * @category   Unic
 * @package    Unic_SaferpayNew
 * @copyright  Copyright (c) 2004-2008 Unic Internet Solutions (http://www.unic.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * SaferpayNew Block Redirect
 *
 * @category   Unic
 * @package    Unic_SaferpayNew
 * @name       Unic_SaferpayNew_Block_Redirect
 * @author     Unic Internet Solutions <magento@unic.com>
 */

class Unic_SaferpayNew_Block_Redirect extends Mage_Core_Block_Abstract {
	protected function _toHtml() {
		$shared = $this->getOrder ()->getPayment ()->getMethodInstance ();
		$url = $shared->getSaferpayNewUrl();
		if($url){
  		$html = '<html>
  		<meta http-equiv="refresh" content="0;url='.$url.'">
  		<body>';
  		$html .= $this->__ ( 'You will be redirected to Saferpay in a few seconds. If not, click next.' );
  		$html .= '<br />';
  		
  		$html .= '<script type="text/javascript">window.document.location.href="'.$url.'";</script>';
  		$html .= '<br /><a href="'.$url.'" >'.$this->__('next').'</a>';
  		$html .= '</body></html>';
		}else{
		  //error
		  $failure_url = Mage::getUrl ( 'saferpaynew/saferpaynew/failure' );
		 	$html = '<html><body>';
  		$html .= $this->__ ( 'There  has been an error  processing  your payment, you will be redirected to the shop in a right now' );
  		$html .= '<br />';
  		
  		$html .= '<script type="text/javascript">window.document.location.href="'.$url.'";</script>';
  		$html .= '<br /><a href="'.$failure_url.'" >'.$this->__('back to shop').'</a>';
  		$html .= '</body></html>';
		}		
		return $html;
	}
}
